<?php
	require_once 'db.php';
	$db = new Db;
	$utakmice = $db->getUtakmice();
	$klubovi = $db->getKlubovi();
?>

<!DOCTYPE html>
<html>

<head>
	<link rel="stylesheet" type="text/css" href="style.css">
</head>

<body>
	
	<h1 id="naslov">SuperLiga Srbije</h1>
	<div class="wrapper">
	
	<?php
		if (isset($_GET["error"])) {
			echo "<div class=\"error\">".$_GET["error"]."</div>";
		}
	?>
	
	<div class="box">
		<h3>Prikaz rezultata odigranih meceva</h3>
		
		<table>
			<tr>
				<th>Domaci</th>
				<th colspan="2">Rezultat</th>
				<th>Gosti</th>
				<td></td><td></td><td></td>
			</tr>
			
			<?php
				
				foreach ($utakmice as $utak) {
					$dom = $db->getKlubById($utak["id_host"]);
					$gos = $db->getKlubById($utak["id_guest"]);
					
			?>
					<tr>
						<td class="tim"><?php echo $dom["ime"]; ?></td>
						<td class="rez"><?php echo $utak["score_host"]; ?></td>
						<td class="rez"><?php echo $utak["score_guest"]; ?></td>
						<td class="tim"><?php echo $gos["ime"]; ?></td>
						<td><a href="index.php?izmena=&id_host=<?php echo $utak["id_host"]; ?>&id_guest=<?php echo $utak["id_guest"]; ?>">Izmeni</a></td>
						<td><a href="brisanje.php?id_host=<?php echo $utak["id_host"]; ?>&id_guest=<?php echo $utak["id_guest"]; ?>">Obrisi</a></td>
						<td><a href="index.php?detalji=&id_host=<?php echo $utak["id_host"]; ?>&id_guest=<?php echo $utak["id_guest"]; ?>">Detalji</a></td>
					</tr>
			<?php
				}
				
			?>
			
		</table>
		
		<br>
		
		<h3>Unos rezultata</h3>
		
		<form method="post" action="dodavanje.php">
			
			Domaci:
			<select name="id_host">
				<?php
					foreach ($klubovi as $klub) {
				?>
						<option value="<?php echo $klub["id"]; ?>"><?php echo $klub["ime"]; ?></option>
				<?php
					}
				?>
			</select>
			<br><br>
			Gosti:
			<select name="id_guest">
				<?php
					foreach ($klubovi as $klub) {
				?>
						<option value="<?php echo $klub["id"]; ?>"><?php echo $klub["ime"]; ?></option>
				<?php
					}
				?>
			</select>
			<br><br>
			Rezultat:
			<input type="number" min="0" name="score_host">:
			<input type="number" min="0" name="score_guest">
			<br><br>
			Opis:
			<textarea name="opis"></textarea>
			<br><br>
			<input type="submit" name="submitUtakmica" value="Dodaj mec!">
		</form>
	</div>
	
	<div class="box">
		<?php
			if (isset($_GET["detalji"]) && isset($_GET["id_host"]) && isset($_GET["id_guest"])) {
				$utakmica = $db->getUtakmica($_GET["id_host"], $_GET["id_guest"]);
		?>
				<h3>Prikaz detalja</h3>
				<p class="desc"><?php echo $utakmica["description"]; ?></p>
				<?php
					$desc = $utakmica["description"];
					$desc = substr($desc, 8);
					$br = count(explode(", ", $desc)) * 2;
					echo "<b>Ima ukupno: $br timova.</b>"
				?>
		<?php
			} else if (isset($_GET["izmena"]) && isset($_GET["id_host"]) && isset($_GET["id_guest"])) {
				$utakmica = $db->getUtakmica($_GET["id_host"], $_GET["id_guest"]);
		?>
				<h3>Izmena rezultata</h3>
				<form action="izmena.php" method="post">
					Domaci:
					<select name="id_host">
						<?php
							foreach ($klubovi as $klub) {
						?>
								<option value="<?php echo $klub["id"]; ?>" <?php if ($klub["id"] == $_GET["id_host"]) echo "selected"; ?>><?php echo $klub["ime"]; ?></option>
						<?php
							}
						?>
					</select>
					<br><br>
					Gosti:
					<select name="id_guest">
						<?php
							foreach ($klubovi as $klub) {
						?>
								<option value="<?php echo $klub["id"]; ?>" <?php if ($klub["id"] == $_GET["id_guest"]) echo "selected"; ?>><?php echo $klub["ime"]; ?></option>
						<?php
							}
						?>
					</select>
					<br><br>
					Rezultat:
					<input type="number" min="0" name="score_host" value="<?php echo $utakmica["score_host"]; ?>">:
					<input type="number" min="0" name="score_guest" value="<?php echo $utakmica["score_guest"]; ?>">
					<br><br>
					<input type="submit" name="submitUtakmicaEdit" value="Izmeni mec!">
				</form>
		<?php
			}
		?>
	</div>
	
	</div>
	
</body>

</html>